/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.QuadTransformer;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.model.TransformationHelper;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.jetbrains.annotations.Nullable;

public class BarrelDynamicModel
implements IModelGeometry<BarrelDynamicModel> {
    public static final Map<String, Map<String, ResourceLocation>> WOOD_TEXTURES = new HashMap<String, Map<String, ResourceLocation>>();
    private static final String BLOCK_FOLDER = "block/";
    private static final String TOP_OPEN_TEXTURE_NAME = "top_open";
    private final Map<String, UnbakedModel> woodModels;
    private final Map<ModelPart, UnbakedModel> additionalModelParts;

    public BarrelDynamicModel(Map<String, UnbakedModel> woodModels, Map<ModelPart, UnbakedModel> additionalModelParts) {
        this.woodModels = woodModels;
        this.additionalModelParts = additionalModelParts;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.woodModels.forEach((woodName, model) -> {
            BakedModel bakedModel = model.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
            if (bakedModel != null) {
                builder.put(woodName, (Object)bakedModel);
            }
        });
        ImmutableMap.Builder additionalModelPartsBuilder = ImmutableMap.builder();
        this.additionalModelParts.forEach((part, model) -> {
            BakedModel bakedModel = model.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
            if (bakedModel != null) {
                additionalModelPartsBuilder.put((Object)part, (Object)bakedModel);
            }
        });
        return new BarrelBakedModel((Map<String, BakedModel>)builder.build(), (Map<ModelPart, BakedModel>)additionalModelPartsBuilder.build());
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.woodModels.forEach((woodName, model) -> builder.addAll((Iterable)model.m_5500_(modelGetter, missingTextureErrors)));
        this.additionalModelParts.forEach((modelPart, model) -> builder.addAll((Iterable)model.m_5500_(modelGetter, missingTextureErrors)));
        return builder.build();
    }

    static {
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach(woodType -> {
            String woodName = woodType.m_61846_();
            HashMap<String, ResourceLocation> barrelTextures = new HashMap<String, ResourceLocation>();
            barrelTextures.put("top", SophisticatedStorage.getRL(BLOCK_FOLDER + woodName + "_barrel_top"));
            barrelTextures.put(TOP_OPEN_TEXTURE_NAME, SophisticatedStorage.getRL(BLOCK_FOLDER + woodName + "_barrel_top_open"));
            barrelTextures.put("bottom", SophisticatedStorage.getRL(BLOCK_FOLDER + woodName + "_barrel_bottom"));
            barrelTextures.put("side", SophisticatedStorage.getRL(BLOCK_FOLDER + woodName + "_barrel_side"));
            WOOD_TEXTURES.put(woodName, barrelTextures);
        });
    }

    private static class BarrelBakedModel
    implements IDynamicBakedModel {
        private static final QuadTransformer MOVE_TO_CORNER = new QuadTransformer(new Transformation(new Vector3f(-0.5f, -0.5f, -0.5f), null, null, null));
        private static final QuadTransformer FLIP_AND_SCALE = new QuadTransformer(new Transformation(null, Vector3f.f_122224_.m_122240_(180.0f), new Vector3f(0.75f, 0.75f, 0.75f), null));
        private static final QuadTransformer ROTATE_90_DEGREES = new QuadTransformer(new Transformation(null, Vector3f.f_122222_.m_122240_(90.0f), null, null));
        private static final Map<Direction, QuadTransformer> DIRECTION_ROTATES = Map.of(Direction.UP, BarrelBakedModel.getDirectionRotationTransform(Direction.UP), Direction.DOWN, BarrelBakedModel.getDirectionRotationTransform(Direction.DOWN), Direction.NORTH, BarrelBakedModel.getDirectionRotationTransform(Direction.NORTH), Direction.SOUTH, BarrelBakedModel.getDirectionRotationTransform(Direction.SOUTH), Direction.WEST, BarrelBakedModel.getDirectionRotationTransform(Direction.WEST), Direction.EAST, BarrelBakedModel.getDirectionRotationTransform(Direction.EAST));
        private static final Map<Direction, QuadTransformer> DIRECTION_MOVES = Map.of(Direction.UP, BarrelBakedModel.getDirectionMoveBackToSide(Direction.UP, 0.5f), Direction.DOWN, BarrelBakedModel.getDirectionMoveBackToSide(Direction.DOWN, 0.5f), Direction.NORTH, BarrelBakedModel.getDirectionMoveBackToSide(Direction.NORTH, 0.5f), Direction.SOUTH, BarrelBakedModel.getDirectionMoveBackToSide(Direction.SOUTH, 0.5f), Direction.WEST, BarrelBakedModel.getDirectionMoveBackToSide(Direction.WEST, 0.5f), Direction.EAST, BarrelBakedModel.getDirectionMoveBackToSide(Direction.EAST, 0.5f));
        private static final Map<Direction, QuadTransformer> DIRECTION_MOVES_3D_ITEMS = Map.of(Direction.UP, BarrelBakedModel.getDirectionMoveBackToSide(Direction.UP, 0.55f), Direction.DOWN, BarrelBakedModel.getDirectionMoveBackToSide(Direction.DOWN, 0.55f), Direction.NORTH, BarrelBakedModel.getDirectionMoveBackToSide(Direction.NORTH, 0.55f), Direction.SOUTH, BarrelBakedModel.getDirectionMoveBackToSide(Direction.SOUTH, 0.55f), Direction.WEST, BarrelBakedModel.getDirectionMoveBackToSide(Direction.WEST, 0.55f), Direction.EAST, BarrelBakedModel.getDirectionMoveBackToSide(Direction.EAST, 0.55f));
        private static final ModelProperty<String> WOOD_NAME = new ModelProperty();
        private static final ModelProperty<Boolean> IS_PACKED = new ModelProperty();
        private static final ModelProperty<Boolean> HAS_MAIN_COLOR = new ModelProperty();
        private static final ModelProperty<Boolean> HAS_ACCENT_COLOR = new ModelProperty();
        private static final ModelProperty<ItemStack> DISPLAY_ITEM = new ModelProperty();
        private static final ModelProperty<Integer> DISPLAY_ITEM_ROTATION = new ModelProperty();
        private static final Map<ItemTransforms.TransformType, Transformation> TRANSFORMS;
        private static final ItemTransforms ITEM_TRANSFORMS;
        private final Map<String, BakedModel> woodModels;
        private final Map<ModelPart, BakedModel> additionalModelParts;
        private final ItemOverrides barrelItemOverrides = new BarrelItemOverrides(this);
        @Nullable
        private String barrelWoodName = null;
        private boolean barrelHasMainColor = false;
        private boolean barrelHasAccentColor = false;
        public boolean barrelIsPacked;
        private static final Map<Integer, QuadTransformer> DISPLAY_ROTATIONS;

        private static QuadTransformer getDirectionRotationTransform(Direction dir) {
            Quaternion rotation = dir.m_122406_();
            if (dir.m_122434_().m_122478_()) {
                rotation.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            return new QuadTransformer(new Transformation(null, rotation, null, null));
        }

        private static QuadTransformer getDirectionMoveBackToSide(Direction dir, float distFromCenter) {
            Vec3i normal = dir.m_122436_();
            Vector3f offset = new Vector3f(distFromCenter, distFromCenter, distFromCenter);
            offset.m_122263_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_());
            offset.m_122272_(0.5f, 0.5f, 0.5f);
            return new QuadTransformer(new Transformation(offset, null, null, null));
        }

        public BarrelBakedModel(Map<String, BakedModel> woodModels, Map<ModelPart, BakedModel> additionalModelParts) {
            this.woodModels = woodModels;
            this.additionalModelParts = additionalModelParts;
        }

        private static ItemTransform fromTransformation(Transformation transformation) {
            return new ItemTransform(transformation.m_121105_().m_175217_(), transformation.m_175940_(), transformation.m_175941_());
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
            boolean isPacked;
            boolean hasAccentColor;
            boolean hasMainColor;
            Object woodName = null;
            if (state != null) {
                hasMainColor = Boolean.TRUE.equals(extraData.getData(HAS_MAIN_COLOR));
                hasAccentColor = Boolean.TRUE.equals(extraData.getData(HAS_ACCENT_COLOR));
                if (extraData.hasProperty(WOOD_NAME)) {
                    woodName = (String)extraData.getData(WOOD_NAME);
                    if (Boolean.TRUE.equals(state.m_61143_((Property)BarrelBlock.OPEN))) {
                        woodName = (String)woodName + "_open";
                    }
                }
                isPacked = extraData.hasProperty(IS_PACKED) && Boolean.TRUE.equals(extraData.getData(IS_PACKED));
            } else {
                woodName = this.barrelWoodName;
                hasMainColor = this.barrelHasMainColor;
                hasAccentColor = this.barrelHasAccentColor;
                isPacked = this.barrelIsPacked;
            }
            ArrayList<BakedQuad> ret = new ArrayList<BakedQuad>();
            if (!hasMainColor || !hasAccentColor) {
                this.addWoodModelQuads(state, side, rand, ret, (String)woodName);
            }
            this.addTintableModelQuads(state, side, rand, ret, hasMainColor, hasAccentColor);
            ret.addAll(this.additionalModelParts.get((Object)ModelPart.TIER).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            if (isPacked) {
                this.addPackedModelQuads(state, side, rand, ret);
            } else {
                this.addDisplayItemQuads(state, side, rand, ret, extraData);
            }
            return ret;
        }

        private void addPackedModelQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret) {
            ret.addAll(this.additionalModelParts.get((Object)ModelPart.PACKED).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
        }

        private void addDisplayItemQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, IModelData extraData) {
            if (state == null || side != null) {
                return;
            }
            ItemStack displayItem = (ItemStack)extraData.getData(DISPLAY_ITEM);
            if (displayItem != null && !displayItem.m_41619_()) {
                Minecraft minecraft = Minecraft.m_91087_();
                ItemRenderer itemRenderer = minecraft.m_91291_();
                BakedModel model = itemRenderer.m_174264_(displayItem, null, (LivingEntity)minecraft.f_91074_, 0);
                ret.clear();
                Integer rotationData = (Integer)extraData.getData(DISPLAY_ITEM_ROTATION);
                int rotation = rotationData == null ? 0 : rotationData;
                for (Direction face : Direction.values()) {
                    this.addRenderedItemSide(state, rand, ret, model, rotation, face);
                }
                this.addRenderedItemSide(state, rand, ret, model, rotation, null);
            }
        }

        private void addRenderedItemSide(BlockState state, Random rand, List<BakedQuad> ret, BakedModel model, int rotation, @Nullable Direction s) {
            List quads = model.m_6840_(null, s, rand);
            quads = MOVE_TO_CORNER.processMany(quads);
            quads = FLIP_AND_SCALE.processMany(quads);
            quads = new QuadTransformer(TransformationHelper.toTransformation((ItemTransform)model.m_7442_().m_111808_(ItemTransforms.TransformType.FIXED))).processMany(quads);
            quads = ROTATE_90_DEGREES.processMany(quads);
            if (rotation != 0) {
                quads = this.getDisplayRotation(rotation).processMany(quads);
            }
            Direction facing = (Direction)state.m_61143_((Property)BarrelBlock.FACING);
            quads = DIRECTION_ROTATES.get(facing).processMany(quads);
            quads = model.m_7539_() ? DIRECTION_MOVES_3D_ITEMS.get(facing).processMany(quads) : DIRECTION_MOVES.get(facing).processMany(quads);
            ret.addAll(quads);
        }

        private QuadTransformer getDisplayRotation(int rotation) {
            return DISPLAY_ROTATIONS.computeIfAbsent(rotation, r -> new QuadTransformer(new Transformation(null, Vector3f.f_122224_.m_122240_((float)rotation), null, null)));
        }

        private void addTintableModelQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, boolean hasMainColor, boolean hasAccentColor) {
            if (hasMainColor) {
                ModelPart modePart = state != null && (Boolean)state.m_61143_((Property)BarrelBlock.OPEN) != false ? ModelPart.MAIN_OPEN : ModelPart.MAIN;
                ret.addAll(this.additionalModelParts.get((Object)modePart).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
            if (hasAccentColor) {
                ret.addAll(this.additionalModelParts.get((Object)ModelPart.ACCENT).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
            if (hasMainColor || hasAccentColor) {
                ret.addAll(this.additionalModelParts.get((Object)ModelPart.METAL_BANDS).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
        }

        private void addWoodModelQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, List<BakedQuad> ret, @Nullable String woodName) {
            if (woodName == null) {
                return;
            }
            if (this.woodModels.containsKey(woodName)) {
                ret.addAll(this.woodModels.get(woodName).getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            } else {
                ret.addAll(this.woodModels.values().iterator().next().getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
            }
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return true;
        }

        public boolean m_7547_() {
            return true;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.woodModels.values().iterator().next().m_6160_();
        }

        public ItemTransforms m_7442_() {
            return ITEM_TRANSFORMS;
        }

        public TextureAtlasSprite getParticleIcon(IModelData data) {
            if (data.hasProperty(HAS_MAIN_COLOR) && Boolean.TRUE.equals(data.getData(HAS_MAIN_COLOR))) {
                return this.additionalModelParts.get((Object)ModelPart.MAIN).getParticleIcon(data);
            }
            if (data.hasProperty(WOOD_NAME)) {
                String name = (String)data.getData(WOOD_NAME);
                if (!this.woodModels.containsKey(name)) {
                    return this.m_6160_();
                }
                return this.woodModels.get(name).getParticleIcon(data);
            }
            return this.m_6160_();
        }

        @Nonnull
        public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
            return WorldHelper.getBlockEntity((BlockGetter)world, (BlockPos)pos, WoodStorageBlockEntity.class).map(be -> {
                ModelDataMap.Builder builder = new ModelDataMap.Builder();
                boolean hasMainColor = be.getStorageWrapper().hasMainColor();
                builder.withInitial(HAS_MAIN_COLOR, (Object)hasMainColor);
                boolean hasAccentColor = be.getStorageWrapper().hasAccentColor();
                builder.withInitial(HAS_ACCENT_COLOR, (Object)hasAccentColor);
                RenderInfo.ItemDisplayRenderInfo itemDisplayRenderInfo = be.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo();
                builder.withInitial(DISPLAY_ITEM, (Object)itemDisplayRenderInfo.getItem());
                builder.withInitial(DISPLAY_ITEM_ROTATION, (Object)itemDisplayRenderInfo.getRotation());
                builder.withInitial(IS_PACKED, (Object)be.isPacked());
                Optional<WoodType> woodType = be.getWoodType();
                if (woodType.isPresent() || !hasMainColor || !hasAccentColor) {
                    builder.withInitial(WOOD_NAME, (Object)woodType.orElse(WoodType.f_61833_).m_61846_());
                }
                return builder.build();
            }).orElse((IModelData)EmptyModelData.INSTANCE);
        }

        public ItemOverrides m_7343_() {
            return this.barrelItemOverrides;
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack matrixStack) {
            if (cameraTransformType == ItemTransforms.TransformType.NONE) {
                return this;
            }
            Transformation tr = TRANSFORMS.get(cameraTransformType);
            if (!tr.isIdentity()) {
                tr.push(matrixStack);
            }
            return this;
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.15625f, 0.0f), new Quaternion(75.0f, 45.0f, 0.0f, true), new Vector3f(0.375f, 0.375f, 0.375f), null));
            builder.put((Object)ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.15625f, 0.0f), new Quaternion(75.0f, 45.0f, 0.0f, true), new Vector3f(0.375f, 0.375f, 0.375f), null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 225.0f, 0.0f, true), new Vector3f(0.4f, 0.4f, 0.4f), null));
            builder.put((Object)ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 45.0f, 0.0f, true), new Vector3f(0.4f, 0.4f, 0.4f), null));
            builder.put((Object)ItemTransforms.TransformType.HEAD, (Object)new Transformation(new Vector3f(0.0f, 0.890625f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(1.0f, 1.0f, 1.0f), null));
            builder.put((Object)ItemTransforms.TransformType.GUI, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(30.0f, 225.0f, 0.0f, true), new Vector3f(0.625f, 0.625f, 0.625f), null));
            builder.put((Object)ItemTransforms.TransformType.GROUND, (Object)new Transformation(new Vector3f(0.0f, 0.1875f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.25f, 0.25f, 0.25f), null));
            builder.put((Object)ItemTransforms.TransformType.FIXED, (Object)new Transformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quaternion(0.0f, 0.0f, 0.0f, true), new Vector3f(0.5f, 0.5f, 0.5f), null));
            TRANSFORMS = builder.build();
            ITEM_TRANSFORMS = new ItemTransforms(BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.HEAD)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GUI)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.GROUND)), BarrelBakedModel.fromTransformation(TRANSFORMS.get(ItemTransforms.TransformType.FIXED)));
            DISPLAY_ROTATIONS = new HashMap<Integer, QuadTransformer>();
        }
    }

    private static enum ModelPart {
        METAL_BANDS(SophisticatedStorage.getRL("block/barrel_metal_bands")),
        ACCENT(SophisticatedStorage.getRL("block/barrel_tintable_accent")),
        MAIN(SophisticatedStorage.getRL("block/barrel_tintable_main")),
        MAIN_OPEN(SophisticatedStorage.getRL("block/barrel_tintable_main_open")),
        TIER(new ResourceLocation("minecraft:block/cube_bottom_top")),
        PACKED(SophisticatedStorage.getRL("block/barrel_packed"));

        private final ResourceLocation modelName;

        private ModelPart(ResourceLocation modelName) {
            this.modelName = modelName;
        }
    }

    public static final class Loader
    implements IModelLoader<BarrelDynamicModel> {
        public static final Loader INSTANCE = new Loader();

        public BarrelDynamicModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableMap.Builder woodModelsBuilder = ImmutableMap.builder();
            WOOD_TEXTURES.forEach((woodName, textures) -> {
                this.addWoodModels((ImmutableMap.Builder<String, UnbakedModel>)woodModelsBuilder, (String)woodName, (Map<String, ResourceLocation>)textures, false);
                this.addWoodModels((ImmutableMap.Builder<String, UnbakedModel>)woodModelsBuilder, woodName + "_open", (Map<String, ResourceLocation>)textures, true);
            });
            ImmutableMap.Builder additionalModelsBuilder = ImmutableMap.builder();
            for (ModelPart modelPart : ModelPart.values()) {
                ImmutableMap textureMap = Collections.emptyMap();
                if (modelPart == ModelPart.TIER && modelContents.has("tierTextures")) {
                    ImmutableMap.Builder texturesBuilder = ImmutableMap.builder();
                    JsonObject texturesJson = modelContents.getAsJsonObject("tierTextures");
                    this.putTierTexture((ImmutableMap.Builder<String, Either<Material, String>>)texturesBuilder, texturesJson, "top");
                    this.putTierTexture((ImmutableMap.Builder<String, Either<Material, String>>)texturesBuilder, texturesJson, "side");
                    this.putTierTexture((ImmutableMap.Builder<String, Either<Material, String>>)texturesBuilder, texturesJson, "bottom");
                    textureMap = texturesBuilder.build();
                }
                additionalModelsBuilder.put((Object)modelPart, (Object)new BlockModel(modelPart.modelName, Collections.emptyList(), textureMap, true, null, ItemTransforms.f_111786_, Collections.emptyList()));
            }
            return new BarrelDynamicModel((Map<String, UnbakedModel>)woodModelsBuilder.build(), (Map<ModelPart, UnbakedModel>)additionalModelsBuilder.build());
        }

        private void putTierTexture(ImmutableMap.Builder<String, Either<Material, String>> texturesBuilder, JsonObject texturesJson, String textureName) {
            ResourceLocation texture = ResourceLocation.m_135820_((String)texturesJson.get(textureName).getAsString());
            if (texture != null) {
                texturesBuilder.put((Object)textureName, (Object)Either.left((Object)new Material(InventoryMenu.f_39692_, texture)));
            }
        }

        private void addWoodModels(ImmutableMap.Builder<String, UnbakedModel> woodModelsBuilder, String woodName, Map<String, ResourceLocation> textures, boolean open) {
            ImmutableMap.Builder textureMapBuilder = ImmutableMap.builder();
            textures.forEach((textureName, rl) -> {
                if (open && textureName.equals("top") || !open && textureName.equals(BarrelDynamicModel.TOP_OPEN_TEXTURE_NAME)) {
                    return;
                }
                if (open && textureName.equals(BarrelDynamicModel.TOP_OPEN_TEXTURE_NAME)) {
                    textureName = "top";
                }
                textureMapBuilder.put(textureName, (Object)Either.left((Object)new Material(InventoryMenu.f_39692_, rl)));
            });
            woodModelsBuilder.put((Object)woodName, (Object)new BlockModel(new ResourceLocation("minecraft:block/cube_bottom_top"), Collections.emptyList(), (Map)textureMapBuilder.build(), true, null, ItemTransforms.f_111786_, Collections.emptyList()));
        }

        public void m_6213_(ResourceManager resourceManager) {
        }
    }

    private static class BarrelItemOverrides
    extends ItemOverrides {
        private final BarrelBakedModel barrelBakedModel;

        public BarrelItemOverrides(BarrelBakedModel barrelBakedModel) {
            this.barrelBakedModel = barrelBakedModel;
        }

        @Nullable
        public BakedModel m_173464_(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            this.barrelBakedModel.barrelHasMainColor = StorageBlockItem.getMainColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelHasAccentColor = StorageBlockItem.getAccentColorFromStack(stack).isPresent();
            this.barrelBakedModel.barrelWoodName = WoodStorageBlockItem.getWoodType(stack).map(WoodType::m_61846_).orElse((String)(this.barrelBakedModel.barrelHasAccentColor && this.barrelBakedModel.barrelHasMainColor ? null : WoodType.f_61833_.m_61846_()));
            this.barrelBakedModel.barrelIsPacked = WoodStorageBlockItem.isPacked(stack);
            return this.barrelBakedModel;
        }
    }
}

